<!— Diverse Suchoptionen für Kunden/Lieferanten -->
## Description

### Funktionen
**lexoffice** bekommt die Mandanten-ID übergeben und liefert eine Selection mit alle Kunden und Lieferanten zurück, die in LO angelegt wurden
**suche** bekommt ein Parameter-Object übergeben und liefert eine Selection zurück
```4D
// Parametrer-Object: $params:=Obj_New("cust_search")
		$0.search:=""
		$0.id_mandant:=0
		$0.type:=0  // 0 ist alle, 1 ist nur cust, 2 ist nur Lief
		$0.lexoffice:=0  // 0 ist alle, 1 nur LO, 2 alle ohne LO
```

```4D
Function suche($searchparams : Object)->$result_o : Object
	/*
		$searchparams.search:=""
		$searchparams.id_mandant:=0
		$searchparams.type:=0  // 0 ist alle, 1 ist nur cust, 2 ist nur Lief
		$searchparams.lexoffice:=0  // 0 ist alle, 1 nur LO, 2 alle ohne LO
	*/
	$result_o:=ds.Kunden.query("cust_name = :1 | cust_matchcode = :1 | cust_zusatz = :1 & _mandantID =:2 & _deleted = False"; $searchparams.search; $searchparams.id_mandant)
	// nach Kunden/Lieferanten filtern?
	Case of 
		: ($searchparams.type=0)
		: ($searchparams.type=1)  // nur Kunden
			$result_o:=$result_o.query("cust_kunde = True")
		: ($searchparams.type=2)  // nur Lieferanten
			$result_o:=$result_o.query("cust_lieferant = True")
	End case 
	
	// nach Lexoffice filtern?
	Case of 
		: ($searchparams.lexoffice=0)
		: ($searchparams.lexoffice=1)  // nur LO
			$result_o:=$result_o.query("cust_lo = True")
		: ($searchparams.lexoffice=2)  // nur nicht LO
			$result_o:=$result_o.query("cust_lo = false")
	End case 
	
	$result_o:=$result_o.orderBy("cust_name asc")
```